(************** Content-type: application/mathematica **************

                    Mathematica-Compatible Notebook

This notebook can be used with any Mathematica-compatible
application, such as Mathematica, MathReader or Publicon. The data
for the notebook starts with the line containing stars above.

To get the notebook into a Mathematica-compatible application, do
one of the following:

* Save the data starting with the line of stars above into a file
  with a name ending in .nb, then open the file inside the
  application;

* Copy the data starting with the line of stars above to the
  clipboard, then use the Paste menu command inside the application.

Data for notebooks contains only printable 7-bit ASCII and can be
sent directly in email or through ftp in text mode.  Newlines can be
CR, LF or CRLF (Unix, Macintosh or MS-DOS style).

NOTE: If you modify the data for this notebook not in a Mathematica-
compatible application, you must delete the line below containing
the word CacheID, otherwise Mathematica-compatible applications may
try to use invalid cache data.

For more information on notebooks and Mathematica-compatible 
applications, contact Wolfram Research:
  web: http://www.wolfram.com
  email: info@wolfram.com
  phone: +1-217-398-0700 (U.S.)

Notebook reader applications are available free of charge from 
Wolfram Research.
*******************************************************************)

(*CacheID: 232*)


(*NotebookFileLineBreakTest
NotebookFileLineBreakTest*)
(*NotebookOptionsPosition[      4015,        138]*)
(*NotebookOutlinePosition[      4680,        161]*)
(*  CellTagsIndexPosition[      4636,        157]*)
(*WindowFrame->Normal*)



Notebook[{
Cell[BoxData[
    \(Do[Plot[{Log[x], Normal[Series[Log[t], {t, 1, i}]] /. t \[Rule] x}, {x, 
          0.01, 4}, PlotStyle \[Rule] {Hue[0], Hue[2/3]}, 
        PlotRange \[Rule] {\(-5\), 5}], {i, 10}]\)], "Input"],

Cell[BoxData[
    \(Plot[{x^2, 4  Cos[x]}, {x, 0, 2  Pi}]\)], "Input"],

Cell[BoxData[
    \(Plot[{x^2, 4  Cos[x]}, {x, 0, 2  Pi}, PlotRange \[Rule] All]\)], "Input"],

Cell[BoxData[
    \(Options[Plot]\)], "Input"],

Cell[BoxData[
    \(\(?Automatic\)\)], "Input"],

Cell[BoxData[
    \(Plot[x^2, {x, 0, 2\ Pi}, 
      PlotRange \[Rule] {{\(-2\), 3}, {\(-1\), 60}}]\)], "Input"],

Cell[BoxData[
    \(InputForm[%]\)], "Input"],

Cell[BoxData[
    \(Plot[x\ Sin[1/x], {x, \(-1\), 1}]\)], "Input"],

Cell[BoxData[
    \(Plot[x\ Sin[1/x], {x, \(- .1\),  .1}, 
      PlotRange \[Rule] {\(- .07\),  .07}]\)], "Input"],

Cell[BoxData[
    \(Plot[x\ Sin[1/x], {x, \(-1\), 1}, 
      PlotRange \[Rule] {\(- .05\),  .05}]\)], "Input"],

Cell[BoxData[
    \(Plot[x\ Sin[1/x], {x, \(- .1\),  .1}]\)], "Input"],

Cell[BoxData[
    \(Plot[Sin[x]/x, {x, 25, 35}]\)], "Input"],

Cell[BoxData[
    \(Plot[{\(-\@\(1 - x\^2\)\), \@\(1 - x\^2\)}, {x, \(-1\), 1}, 
      AspectRatio \[Rule] Automatic, AxesLabel \[Rule] {"\<x\>", "\<\>"}, 
      PlotLabel -> "\<circunferencia\>", 
      Ticks \[Rule] {{\(-4\)/5, \(-1\)/3, 1/2}, {\(-3\)/5, 1/4, 
            2/3, {0.95, "\<y\>"}}}, 
      Background \[Rule] RGBColor[1, 3/4, 1/2]]\)], "Input"],

Cell[BoxData[
    \(f[n_, x_] := Floor[N[10^n\ \ x]]/10^n\)], "Input"],

Cell[BoxData[
    \(h[n_, x_] = Sum[f[k, x], {k, 0, n}]\)], "Input"],

Cell[BoxData[
    \(Clear[f, h]\)], "Input"],

Cell[BoxData[
    \(f[r_] := Function[x, r\ x \((1 - x)\)]\)], "Input"],

Cell[BoxData[
    \(f[r_, x_, n_] := Nest[f[r], x, 2^\((n - 1)\)]\)], "Input"],

Cell[BoxData[
    \(f[4]\)], "Input"],

Cell[BoxData[
    \(f[3.5546, x, 4]\)], "Input"],

Cell[BoxData[
    \(Expand[%]\)], "Input"],

Cell[BoxData[
    \(f[3.5546, 0.33, 6]\)], "Input"],

Cell[BoxData[
    \(Plot[f[2, x, 1], {x, 0, 1}]\)], "Input"],

Cell[BoxData[
    \(p25 = Plot[f[3.5, x, 10], {x, 0, 1}, PlotRange \[Rule] All]\)], "Input"],

Cell[BoxData[
    \(Show[Out[108], PlotRange \[Rule] {0.2, 0.7}]\)], "Input"],

Cell[BoxData[
    \(Plot[x^2, {x, 0, 1}, PlotStyle \[Rule] Thickness[0.02]]\)], "Input"]
},
FrontEndVersion->"4.1 for Microsoft Windows",
ScreenRectangle->{{0, 1024}, {0, 680}},
WindowSize->{1016, 648},
WindowMargins->{{0, Automatic}, {Automatic, 0}},
ShowSelection->True
]

(*******************************************************************
Cached data follows.  If you edit this Notebook file directly, not
using Mathematica, you must remove the line containing CacheID at
the top of  the file.  The cache data will then be recreated when
you save this file from within Mathematica.
*******************************************************************)

(*CellTagsOutline
CellTagsIndex->{}
*)

(*CellTagsIndex
CellTagsIndex->{}
*)

(*NotebookFileOutline
Notebook[{
Cell[1705, 50, 213, 3, 50, "Input"],
Cell[1921, 55, 70, 1, 30, "Input"],
Cell[1994, 58, 93, 1, 30, "Input"],
Cell[2090, 61, 46, 1, 30, "Input"],
Cell[2139, 64, 47, 1, 30, "Input"],
Cell[2189, 67, 111, 2, 30, "Input"],
Cell[2303, 71, 45, 1, 30, "Input"],
Cell[2351, 74, 66, 1, 30, "Input"],
Cell[2420, 77, 114, 2, 30, "Input"],
Cell[2537, 81, 110, 2, 30, "Input"],
Cell[2650, 85, 70, 1, 30, "Input"],
Cell[2723, 88, 60, 1, 30, "Input"],
Cell[2786, 91, 360, 6, 56, "Input"],
Cell[3149, 99, 70, 1, 30, "Input"],
Cell[3222, 102, 68, 1, 30, "Input"],
Cell[3293, 105, 44, 1, 30, "Input"],
Cell[3340, 108, 71, 1, 30, "Input"],
Cell[3414, 111, 78, 1, 30, "Input"],
Cell[3495, 114, 37, 1, 30, "Input"],
Cell[3535, 117, 48, 1, 30, "Input"],
Cell[3586, 120, 42, 1, 30, "Input"],
Cell[3631, 123, 51, 1, 30, "Input"],
Cell[3685, 126, 60, 1, 30, "Input"],
Cell[3748, 129, 92, 1, 30, "Input"],
Cell[3843, 132, 77, 1, 30, "Input"],
Cell[3923, 135, 88, 1, 30, "Input"]
}
]
*)



(*******************************************************************
End of Mathematica Notebook file.
*******************************************************************)

